
	_hype.Apply = ({
			'${DomID}' : function (value, element) {
				// no-op, dom ids are set in createSceneDivs
			},

			'${Top}' : function (value, element) {
				element.setAttribute("${HYPE_Top}", value);
				_hype.Apply.UpdateFrame(element);
			},

			'${Left}' : function (value, element) {
				element.setAttribute("${HYPE_Left}", value);
				_hype.Apply.UpdateFrame(element);
			},
			
			'${Width}' : function (value, element) {
				element.setAttribute("${HYPE_Width}", value);
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},

			'${Height}' : function (value, element) {
				element.setAttribute("${HYPE_Height}", value);
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},
			
			UpdateFrame : function (element) {
				try {
					_hype.Apply._UpdateFrame(element);
				} catch(err) { }
			},
			
			_UpdateFrame : function (element) {
				if(_hype.shouldQueueFrameUpdates == true) {
					_hype.elementsNeedingFrameUpdates[element.id] = element;
					return;
				}
			
				var autoresizingMask = parseInt(element.getAttribute("${HYPE_AutoresizingMask}"));
				if(isNaN(autoresizingMask)) {
					autoresizingMask = 0;
				}
				var useTranslates = (_hype.browserInfo.webkit != null && element.getAttribute("${HYPE_useTranslates}") == "1");
				
				var elementOid = _hype.idReverseMapping[element.id];
				var parentOid = _hype.parentOidForElementOid(elementOid);
				
				var originalContainerSize = _hype.currentSizeForElementOid(parentOid);
				var currentContainerSize = _hype.browserReportedSizeForElementOid(parentOid);
				var currentElementSize = _hype.currentSizeForElementOid(elementOid);
				
				var leftValue = element.getAttribute("${HYPE_Left}");
				var topValue = element.getAttribute("${HYPE_Top}");
				var widthValue = element.getAttribute("${HYPE_Width}");
				var heightValue = element.getAttribute("${HYPE_Height}");

				leftValue = (leftValue != null) ? parseFloat(leftValue) : 0;
				topValue = (topValue != null) ? parseFloat(topValue) : 0;
				
				// if there's been no width/height is likely a text box without explicit dimensions. We still need to know what it is, but should not set it.
				var shouldSetWidth = true;
				var shouldSetHeight = true;

				if(widthValue != null) {
					widthValue = parseFloat(widthValue);
				} else {
					shouldSetWidth = false;
					widthValue = currentElementSize.width;
				}
				if(heightValue != null) {
					heightValue = parseFloat(heightValue);
				} else {
					shouldSetHeight = false;
					heightValue = currentElementSize.height;
				}

				var fullWidth = _hype.currentWidthForElementWithOid(elementOid);
				var fullHeight = _hype.currentHeightForElementWithOid(elementOid);
				var widthDelta = fullWidth - widthValue;
				var heightDelta = fullHeight - heightValue;

				var calculatedLeft = leftValue;
				var calculatedTop = topValue;
				var calculatedWidth = widthValue;
				var calculatedHeight = heightValue;
				
				if(_hype.usesFlexibleLayout == true && autoresizingMask != 0 && autoresizingMask != 36) {
					var isMinXMargin = (autoresizingMask & _hype.NSViewMinXMargin) != 0;
					var isMaxXMargin = (autoresizingMask & _hype.NSViewMaxXMargin) != 0;
					var isWidthSizable = (autoresizingMask & _hype.NSViewWidthSizable) != 0;
					var isMinYMargin = (autoresizingMask & _hype.NSViewMinYMargin) != 0;
					var isMaxYMargin = (autoresizingMask & _hype.NSViewMaxYMargin) != 0;
					var isHeightSizable = (autoresizingMask & _hype.NSViewHeightSizable) != 0;
					var isScaleShrink = ((autoresizingMask & _hype.kHypeViewScaleShrink) != 0) && (isWidthSizable == true) && (isHeightSizable == true);
					var isScaleExpand = ((autoresizingMask & _hype.kHypeViewScaleExpand) != 0) && (isWidthSizable == true) && (isHeightSizable == true);
					var shouldPreserveProportions = (isScaleShrink == true || isScaleExpand == true);

					var widthResizeRatio = (currentContainerSize.width / originalContainerSize.width);
					var heightResizeRatio = (currentContainerSize.height / originalContainerSize.height);
					
					if(isMinXMargin == true && isMaxXMargin == false && isWidthSizable == false) {
						calculatedLeft = (currentContainerSize.width - originalContainerSize.width) + leftValue;
					} else if(isMinXMargin == true && isMaxXMargin == true && isWidthSizable == false) {
						var centerPoint = (leftValue + (fullWidth / 2));
						calculatedLeft = (centerPoint * widthResizeRatio) - (fullWidth / 2);
					} else if(isMinXMargin == true && isMaxXMargin == true && isWidthSizable == true) {
						calculatedWidth = (fullWidth + (currentContainerSize.width - originalContainerSize.width)) - widthDelta;
					} else if(isWidthSizable == true) {
						calculatedWidth = Math.ceil((fullWidth * widthResizeRatio) - widthDelta);
						if(isMinXMargin == true && isMaxXMargin == false) {
							calculatedLeft = (currentContainerSize.width - originalContainerSize.width) + leftValue - (calculatedWidth - widthValue);
						}
					}
					
					if(isMinYMargin == true && isMaxYMargin == false && isHeightSizable == false) {
						calculatedTop = (currentContainerSize.height - originalContainerSize.height) + topValue;
					} else if(isMinYMargin == true && isMaxYMargin == true && isHeightSizable == false) {
						var centerPoint = (topValue + (fullHeight / 2));
						calculatedTop = (centerPoint * heightResizeRatio) - (fullHeight / 2);
					} else if(isMinYMargin == true && isMaxYMargin == true && isHeightSizable == true) {
						calculatedHeight = (fullHeight + (currentContainerSize.height - originalContainerSize.height)) - heightDelta;
					} else if(isHeightSizable == true) {
						calculatedHeight = Math.ceil((fullHeight * heightResizeRatio) - heightDelta);
						if(isMinYMargin == true && isMaxYMargin == false) {
							calculatedTop = (currentContainerSize.height - originalContainerSize.height) + topValue - (calculatedHeight - heightValue);
						}
					}
					
					if(shouldPreserveProportions == true) {
						var previouslyCalculatedCalculatedWidth = calculatedWidth;
						var previouslyCalculatedCalculatedHeight = calculatedHeight;
						var proportionalWidthResizeRatio = (calculatedWidth / widthValue);
						var proportionalHeightResizeRatio = (calculatedHeight / heightValue);
						var proportionalResizeRatio = proportionalWidthResizeRatio;
						
						if(isScaleShrink == true) { // choose largest
							proportionalResizeRatio = (proportionalWidthResizeRatio <= proportionalHeightResizeRatio) ? proportionalWidthResizeRatio : proportionalHeightResizeRatio;
						} else if(isScaleExpand == true) { // choose smallest
							proportionalResizeRatio = (proportionalWidthResizeRatio >= proportionalHeightResizeRatio) ? proportionalWidthResizeRatio : proportionalHeightResizeRatio;
						}
						
						calculatedWidth = widthValue * proportionalResizeRatio;
						calculatedHeight = heightValue * proportionalResizeRatio;
						
						var proportionalWidthDelta = previouslyCalculatedCalculatedWidth - calculatedWidth;
						var proportionalHeightDelta = previouslyCalculatedCalculatedHeight - calculatedHeight;
						
						if(isMinXMargin == true && isMaxXMargin == false) { // need to bottom-align
							calculatedLeft += proportionalWidthDelta
						} else if(isMinXMargin == true && isMaxXMargin == true) { // need to center
							calculatedLeft += (proportionalWidthDelta / 2);
						}
						
						if(isMinYMargin == true && isMaxYMargin == false) { // need to bottom-align
							calculatedTop += proportionalHeightDelta;
						} else if(isMinYMargin == true && isMaxYMargin == true) { // need to center
							calculatedTop += (proportionalHeightDelta / 2);
									
						}
					}
				}
		
				if(shouldSetWidth == true) {
					element.style.width = "" + (Math.max(0, calculatedWidth)) + "px";
				} else {
					element.style.width = "";
				}
				
				if(shouldSetHeight == true) {
					element.style.height = "" + (Math.max(0, calculatedHeight)) + "px";
				} else {
					element.style.height = "";
				}
				
${ifdef supportInternetExplorer6789}
				if(_hype.browserInfo.ie < 8) {
					// fix inner image sizing
					var imgId = "img_" + element.id;
					var imgElement = document.getElementById(imgId);
					if(imgElement != null) {
						var updateImageFrameFunction = (function () {
							imgElement.style.width = "" + element.clientWidth + "px";
							imgElement.style.height = "" + element.clientHeight + "px";
						});
						
						if(element.clientWidth == 0 && element.clientHeight == 0) {
							// need to defer since IE hasn't fully setup the element yet
							window.setTimeout(updateImageFrameFunction, 0);
						} else {
							updateImageFrameFunction();
						}
							
					}
				}
				
				if(_hype.browserInfo.ie < 9) {
					// fix rotation
					var rotateAngleValue = element.getAttribute("${HYPE_RotationAngleZ}");
					if(rotateAngleValue != null) {
						_hype.Apply['${RotationAngleZ}'](rotateAngleValue, element);
					}
				
					// for IE QT plugin	
					var embedobj = element.ownerDocument.embeds["embedobj_" + element.id];
					if(embedobj != null) {
						embedobj.setAttribute("width", calculatedWidth);
						embedobj.setAttribute("height", calculatedHeight);
					}
				}
${endif}
				
				if(useTranslates == false) {
${ifdef supportInternetExplorer6789}
					var offsetTop = element.getAttribute("${HYPE_MS_rotation_offset_top}");
					var offsetLeft = element.getAttribute("${HYPE_MS_rotation_offset_left}");
					if(offsetTop != null) {
						calculatedTop = parseInt(offsetTop) + calculatedTop;
					}
					if(offsetLeft != null) {
						calculatedLeft = parseInt(offsetLeft) + calculatedLeft;
					}
${endif}
					
					element.style.top = "" + calculatedTop + "px";
					element.style.left = "" + calculatedLeft + "px";
				} else {
					element.setAttribute("${HYPE_CalculatedTop}", ("" + calculatedTop + "px"));
					element.setAttribute("${HYPE_CalculatedLeft}", ("" + calculatedLeft + "px"));
					_hype.Apply.ApplyTransforms(element);
				}
			},
			
			'${Depth}' : function (value, element) {
				if(_hype.browserInfo.webkit != null && element.getAttribute("${HYPE_useTranslates}") == "1") {
					element.setAttribute("${HYPE_Depth}", value);
					_hype.Apply.ApplyTransforms(element);
				}
			},

			ApplyTransforms : function (element) {
				var leftValue = element.getAttribute("${HYPE_CalculatedLeft}");
				var topValue = element.getAttribute("${HYPE_CalculatedTop}");
				var depthValue = element.getAttribute("${HYPE_Depth}");
				var rotateAngleXValue = element.getAttribute("${HYPE_RotationAngleX}");
				var rotateAngleYValue = element.getAttribute("${HYPE_RotationAngleY}");
				var rotateAngleZValue = element.getAttribute("${HYPE_RotationAngleZ}");
				var motionPathRotation = element.getAttribute("${HYPE_MotionPathRotation}");
				var transformOriginXOffset = element.getAttribute("${HYPE_TransformOriginXOffset}");
				var transformOriginYOffset = element.getAttribute("${HYPE_TransformOriginYOffset}");
				var transformString = "";
				
				if(leftValue != null) {
					transformString += " translateX(" + leftValue + ") ";
				}
				if(topValue != null) {
					transformString += " translateY(" + topValue + ") ";
				}
				if(depthValue != null) {
					transformString += " translateZ(" + depthValue + ") ";
				}
				if(motionPathRotation != null) {
				   if (element.getAttribute("${HYPE_RotationFollowsMotionPath}") == "YES") {
						transformString += " rotate(" + motionPathRotation + ") ";
					}
				}
				if(rotateAngleZValue != null) {
					transformString += " rotate(" + rotateAngleZValue + ") ";
				}
				if(!(_hype.browserInfo.ie < 10)) {
					if(rotateAngleYValue != null) {
						transformString += " rotateY(" + rotateAngleYValue + ") ";
					} else if(_hype.graphicsAcceleration == true) {
						transformString += " rotateY(0) ";
					}
					if(rotateAngleXValue != null) {
						transformString += " rotateX(" + rotateAngleXValue + ") ";
					}
				}

				var transformOriginXOffsetString = "50%";
				if(transformOriginXOffset != null) {
					transformOriginXOffsetString = transformOriginXOffset;
				}
				var transformOriginYOffsetString = "50%";
				if(transformOriginYOffset != null) {
					transformOriginYOffsetString = transformOriginYOffset;
				}
				element.style[_hype.kSizeOptimizationWebKitPrefix + "transform-origin"] = transformOriginXOffsetString + " " + transformOriginYOffsetString;
				element.style["MozTransformOrigin"] = transformOriginXOffsetString + " " + transformOriginYOffsetString;
				element.style["OTransformOrigin"] = transformOriginXOffsetString + " " + transformOriginYOffsetString;
				element.style["-ms-transform-origin"] = transformOriginXOffsetString + " " + transformOriginYOffsetString;

				element.style[_hype.kSizeOptimizationWebKitPrefix + "transform"] = transformString;
				element.style["MozTransform"] = transformString;
				element.style["OTransform"] = transformString;
				element.style["-ms-transform"] = transformString;
			},
			
			'${AutoresizingMask}' : function (value, element) {
				element.setAttribute("${HYPE_AutoresizingMask}", value);
				_hype.Apply.UpdateFrame(element);
			},
			
			'${FontSize}' : function (value, element) {
				element.style.fontSize = value;
			},
			
			'${FontFamily}' : function (value, element) {
				element.style.fontFamily = value;
			},
			
			'${FontWeight}' : function (value, element) {
				element.style.fontWeight = value;
			},
			
			'${FontStyle}' : function (value, element) {
				element.style.fontStyle = value;
			},
			
			'${TextDecoration}' : function (value, element) {
				element.style.textDecoration = value;
			},
			
			'${TextAlign}' : function (value, element) {
				element.style.textAlign = value;
			},
			
			'${TextColor}' : function (value, element) {
				element.style.color = value;
			},
			
			'${LetterSpacing}' : function (value, element) {
				element.style.letterSpacing = value;
			},
			
			'${WordSpacing}' : function (value, element) {
				element.style.wordSpacing = value;
			},
			
			'${LineHeight}' : function (value, element) {
				element.style.lineHeight = value;
			},

			'${ReflectionOffset}' : function (value, element) {
				element.setAttribute("${HYPE_ReflectionOffset}", value);

				var reflectionDepth = element.getAttribute("${HYPE_ReflectionDepth}");
				if(reflectionDepth != null) {
					_hype.Apply['${ReflectionDepth}'](reflectionDepth, element);
				}
			},

			'${ReflectionDepth}' : function (value, element) {
				element.setAttribute("${HYPE_ReflectionDepth}", value);
				
				var reflectionOffset = element.getAttribute("${HYPE_ReflectionOffset}");
				if(reflectionOffset == null) {
					//TODO: make it so this value comes from the same place for HypeAttribute and the javascript
					reflectionOffset = "8px";
				}
				
				if(_hype.browserInfo.android == null) {
					if((1.0 - value) == 1.0 && element.style.removeProperty != null) {
						element.style.removeProperty(_hype.kSizeOptimizationWebKitPrefix + "box-reflect");
					} else {
						element.style[_hype.kSizeOptimizationWebKitPrefix + "box-reflect"] = "below " + reflectionOffset + " -webkit-gradient(linear,left top,left bottom,from(transparent),color-stop(" + (1.0 - value) + ",transparent),to(rgba(255,255,255,.5)))";
					}
				}
			},

			'${RotationAngleZ}' : function (value, element) {
				element.setAttribute("${HYPE_RotationAngleZ}", value);

${ifdef supportInternetExplorer6789}
				// ie 6-8
				if(_hype.browserInfo.ie < 9) {
					_hype.Apply.ApplyMSFilters(element);
				} else {
${endif}
					_hype.Apply.ApplyTransforms(element);
${ifdef supportInternetExplorer6789}
				}
${endif}
			},

			'${RotationAngleX}' : function (value, element) {
				element.setAttribute("${HYPE_RotationAngleX}", value);				
				_hype.Apply.ApplyTransforms(element);
			},
			
			'${RotationAngleY}' : function (value, element) {
				element.setAttribute("${HYPE_RotationAngleY}", value);
				_hype.Apply.ApplyTransforms(element);
			},

			'${TransformOriginXOffset}' : function (value, element) {
				element.setAttribute("${HYPE_TransformOriginXOffset}", value);
${ifdef supportInternetExplorer6789}
				if (_hype.browserInfo.ie < 9) {
					_hype.Apply.ApplyMSFilters(element);
				} else {
${endif}
					_hype.Apply.ApplyTransforms(element);
${ifdef supportInternetExplorer6789}
				}
${endif}
			},

			'${TransformOriginYOffset}' : function (value, element) {
				element.setAttribute("${HYPE_TransformOriginYOffset}", value);
${ifdef supportInternetExplorer6789}
				if (_hype.browserInfo.ie < 9) {
					_hype.Apply.ApplyMSFilters(element);
				} else {
${endif}
					_hype.Apply.ApplyTransforms(element);
${ifdef supportInternetExplorer6789}
				}
${endif}
			},

			'${MotionPathRotation}' : function (value, element) {
				element.setAttribute("${HYPE_MotionPathRotation}", value);
${ifdef supportInternetExplorer6789}
				if (_hype.browserInfo.ie < 9) {
					_hype.Apply.ApplyMSFilters(element);
				} else {
${endif}
					_hype.Apply.ApplyTransforms(element);
${ifdef supportInternetExplorer6789}
				}
${endif}
			},

			'${RotationFollowsMotionPath}' : function (value, element) {
				element.setAttribute("${HYPE_RotationFollowsMotionPath}", value);
			},

${ifdef supportInternetExplorer6789}	
			ApplyMSFilters : function (element) {
				var opacity8 = element.getAttribute("${HYPE_MS_opacity8}");
				var opacity5 = element.getAttribute("${HYPE_MS_opacity5}");
				var rotation = element.getAttribute("${HYPE_RotationAngleZ}");
				var motionPathRotation = null;
				if(element.getAttribute("${HYPE_RotationFollowsMotionPath}") == "YES") {
					motionPathRotation = element.getAttribute("${HYPE_MotionPathRotation}");
				}
				var background = element.getAttribute("${HYPE_MS_background}");
				var imageSource = element.getAttribute("${HYPE_MS_image_loader}");

				var filterText = "";
				var rotating = (rotation != null || motionPathRotation != null);

				var height = element.clientHeight;
				if (element.style.borderTopWidth != "") {
					height += parseInt(element.style.borderTopWidth);
				}
				if (element.style.borderBottomWidth != "") {
					height += parseInt(element.style.borderBottomWidth);
				}

				var width = element.clientWidth;
				if (element.style.borderLeftWidth != "") {
					width += parseInt(element.style.borderLeftWidth);
				}
				if (element.style.borderRightWidth != "") {
					width += parseInt(element.style.borderRightWidth);
				}

				if(opacity8 != null) {
					filterText += " " + opacity8;
				}
				if(opacity5 != null) {
					filterText += " " + opacity5;
				}

				var transformMatrix;
				if (rotating == true) {
					function matrixMultiply(leftMatrix, rightMatrix) {
						var result = [[0, 0, 0], [0, 0, 0], [0, 0, 0]];

						result[0][0] = leftMatrix[0][0] * rightMatrix[0][0] + leftMatrix[0][1] * rightMatrix[1][0] + leftMatrix[0][2] * rightMatrix[2][0];
						result[0][1] = leftMatrix[0][0] * rightMatrix[0][1] + leftMatrix[0][1] * rightMatrix[1][1] + leftMatrix[0][2] * rightMatrix[2][1];
						result[0][2] = leftMatrix[0][0] * rightMatrix[0][2] + leftMatrix[0][1] * rightMatrix[1][2] + leftMatrix[0][2] * rightMatrix[2][2];

						result[1][0] = leftMatrix[1][0] * rightMatrix[0][0] + leftMatrix[1][1] * rightMatrix[1][0] + leftMatrix[1][2] * rightMatrix[2][0];
						result[1][1] = leftMatrix[1][0] * rightMatrix[0][1] + leftMatrix[1][1] * rightMatrix[1][1] + leftMatrix[1][2] * rightMatrix[2][1];
						result[1][2] = leftMatrix[1][0] * rightMatrix[0][2] + leftMatrix[1][1] * rightMatrix[1][2] + leftMatrix[1][2] * rightMatrix[2][2];

						result[2][0] = leftMatrix[2][0] * rightMatrix[0][0] + leftMatrix[2][1] * rightMatrix[1][0] + leftMatrix[2][2] * rightMatrix[2][0];
						result[2][1] = leftMatrix[2][0] * rightMatrix[0][1] + leftMatrix[2][1] * rightMatrix[1][1] + leftMatrix[2][2] * rightMatrix[2][1];
						result[2][2] = leftMatrix[2][0] * rightMatrix[0][2] + leftMatrix[2][1] * rightMatrix[1][2] + leftMatrix[2][2] * rightMatrix[2][2];

						return result;
					}

					var transformOriginXOffsetPercentage = element.getAttribute("${HYPE_TransformOriginXOffset}") ? (parseInt(element.getAttribute("${HYPE_TransformOriginXOffset}")) / 100.0) : 0.5;
					var transformOriginYOffsetPercentage = element.getAttribute("${HYPE_TransformOriginYOffset}") ? (parseInt(element.getAttribute("${HYPE_TransformOriginYOffset}")) / 100.0) : 0.5;
					var transformOriginXOffsetPixels = (transformOriginXOffsetPercentage * width);
					var transformOriginYOffsetPixels = (transformOriginYOffsetPercentage * height);
					var transformOriginTranslationMatrix = [[1, 0, transformOriginXOffsetPixels], [0, 1, transformOriginYOffsetPixels], [0, 0, 1]];
					var reverseTransformOriginTranslationMatrix = [[1, 0, -transformOriginXOffsetPixels], [0, 1, -transformOriginYOffsetPixels], [0, 0, 1]];

					var rotationInt = (rotation != null) ? parseInt(rotation) : 0;
					var motionPathRotationInt = (motionPathRotation != null) ? parseInt(motionPathRotation) : 0;
					var radians = Math.PI * ((rotationInt + motionPathRotationInt) / 180);
					var costheta = Math.cos(radians);
					var sintheta = Math.sin(radians);
					var rotationMatrix = [[costheta, -sintheta, 0], [sintheta, costheta, 0], [0, 0, 1]];
					transformMatrix = matrixMultiply(matrixMultiply(transformOriginTranslationMatrix, rotationMatrix), reverseTransformOriginTranslationMatrix);

					var rotationString = _hype.kSizeOptimizationMSFilterPrefix + ".Matrix(M11=" + transformMatrix[0][0] + ",M12=" + transformMatrix[0][1] + ",M21=" + transformMatrix[1][0] + ",M22=" + transformMatrix[1][1] + ",SizingMethod='auto expand')";

					filterText += " " + rotationString;
				}
				if(background != null) {
					filterText += " " + background;
				}
				if(imageSource != null) {
					filterText += " " + imageSource;
				}

				element.style["filter"] = filterText;

				if (rotating == true) {
					// Shift elements to account for any transform origin offset
					function vectorMultiply(matrix, vector) {
						var result = [0, 0, 0];

						result[0] = matrix[0][0] * vector[0] + matrix[0][1] * vector[1] + matrix[0][2] * vector[2];
						result[1] = matrix[1][0] * vector[0] + matrix[1][1] * vector[1] + matrix[1][2] * vector[2];
						result[2] = matrix[2][0] * vector[0] + matrix[2][1] * vector[1] + matrix[2][2] * vector[2];

						return result;
					}

					var corners = {
						topLeft: [0, 0, 1],
						topRight: [width, 0, 1],
						bottomLeft: [0, height, 1],
						bottomRight: [width, height, 1]
					}

					var transformOffsetLeft;
					var transformOffsetTop;

					for (var corner in corners) {
						var transformedPoint = vectorMultiply(transformMatrix, corners[corner]);

						if ((typeof transformOffsetLeft === "undefined") || (transformedPoint[0] < transformOffsetLeft)) {
							transformOffsetLeft = transformedPoint[0];
						}

						if ((typeof transformOffsetTop === "undefined") || (transformedPoint[1] < transformOffsetTop)) {
							transformOffsetTop = transformedPoint[1];
						}
					}

					// Round to better match WebKit's rendering
					transformOffsetLeft = parseInt(transformOffsetLeft.toFixed(0));
					transformOffsetTop = parseInt(transformOffsetTop.toFixed(0));

					element.setAttribute("${HYPE_MS_rotation_offset_left}", transformOffsetLeft);
					element.setAttribute("${HYPE_MS_rotation_offset_top}", transformOffsetTop);
					element.style.left = parseInt(_hype.currentValues[_hype.idReverseMapping[element.id]]["${Left}"]) + transformOffsetLeft;
					element.style.top = parseInt(_hype.currentValues[_hype.idReverseMapping[element.id]]["${Top}"]) + transformOffsetTop;
				}
			},
${endif}

			'${Opacity}' : function (value, element) {
${ifdef supportInternetExplorer6789}
				if(_hype.browserInfo.ie < 9 || _hype.browserInfo.quirksmode) {
					if(parseInt(value) == 1.0) {
						// ie 8
						element.removeAttribute("${HYPE_MS_opacity8}");
						// ie 5-7
						element.removeAttribute("${HYPE_MS_opacity5}");	
					} else {
						var alphaString = "Alpha(Opacity=" + Math.round(value * 100) + ")";
						// ie 8
						element.setAttribute("${HYPE_MS_opacity8}", _hype.kSizeOptimizationMSFilterPrefix + "." + alphaString);
						// ie 5-7
						element.setAttribute("${HYPE_MS_opacity5}", alphaString.toLowerCase());
						
						// set a transparent background image so clicks still work when there is opacity in IE and no backgroundImage/color
						if(element.style.backgroundColor == "" && element.style.backgroundImage == "") {
							var imgId = "img_" + element.id;
							var imgElement = document.getElementById(imgId);
							if(imgElement == null) {
								element.style.backgroundImage = "url('" + escapeURLForCSS(_hype.resourcePathForBlankGif()) + "')";
							}
						}
					}
					_hype.Apply.ApplyMSFilters(element);
				}
${endif}
			
				// others
				element.style.opacity = value;
				element.style.MozOpacity = value;
			},
			
			'${Cursor}' : function (value, element) {
				element.style.cursor = value;
			},
			
			'${UserSelect}' : function (value, element) {
				// webkit
				element.style[_hype.kSizeOptimizationWebKitPrefix + "user-select"] = value;
				
				// mozilla
				element.style["MozUserSelect"] = value;
				
				// ie
				element["onselectstart"] = (function() { return false; });
			},

			'${BorderWidthLeft}' : function (value, element) {
				element.style.borderLeftWidth = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},

			'${BorderWidthRight}' : function (value, element) {
				element.style.borderRightWidth = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},

			'${BorderWidthTop}' : function (value, element) {
				element.style.borderTopWidth = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},

			'${BorderWidthBottom}' : function (value, element) {
				element.style.borderBottomWidth = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},

			'${BorderColorLeft}' : function (value, element) {
				element.style.borderLeftColor = value;
			},

			'${BorderColorRight}' : function (value, element) {
				element.style.borderRightColor = value;
			},

			'${BorderColorTop}' : function (value, element) {
				element.style.borderTopColor = value;
			},

			'${BorderColorBottom}' : function (value, element) {
				element.style.borderBottomColor = value;
			},

			'${BorderStyleLeft}' : function (value, element) {
				element.style.borderLeftStyle = value;
			},

			'${BorderStyleRight}' : function (value, element) {
				element.style.borderRightStyle = value;
			},

			'${BorderStyleTop}' : function (value, element) {
				element.style.borderTopStyle = value;
			},

			'${BorderStyleBottom}' : function (value, element) {
				element.style.borderBottomStyle = value;
			},

${ifdef supportInternetExplorer6789}			
			MSBorderRadius : function (element) {
				var topLeft = element.getAttribute("${HYPE_MS_BorderTopLeftRadius}");
				if(topLeft == null) {
					topLeft = "0";
				}
				var topRight = element.getAttribute("${HYPE_MS_BorderTopRightRadius}");
				if(topRight == null) {
					topRight = "0";
				}
				var bottomLeft = element.getAttribute("${HYPE_MS_BorderBottomLeftRadius}");
				if(bottomLeft == null) {
					bottomLeft = "0";
				}
				var bottomRight = element.getAttribute("${HYPE_MS_BorderBottomRightRadius}");
				if(bottomRight == null) {
					bottomRight = "0";
				}
				
				element.style["border-radius"] = "" + topLeft + " " + topRight + " " + bottomRight + " " + bottomLeft;
			},
${endif}
			
			'${BorderRadiusTopLeft}' : function (value, element) {
				element.style['borderTopLeftRadius'] = value;
				
				// firefox 3.6
				element.style["MozBorderRadiusTopleft"] = value;
				
${ifdef supportInternetExplorer6789}
				// PIE IE
				if(_hype.browserInfo.ie < 9) {
					element.setAttribute("${HYPE_MS_BorderTopLeftRadius}", value);
					_hype.Apply.MSBorderRadius(element);
				}
${endif}
			},
			
			'${BorderRadiusTopRight}' : function (value, element) {
				element.style['borderTopRightRadius'] = value;

				// firefox 3.6
				element.style["MozBorderRadiusTopright"] = value;

${ifdef supportInternetExplorer6789}
				// PIE IE
				if(_hype.browserInfo.ie < 9) {
					element.setAttribute("${HYPE_MS_BorderTopRightRadius}", value);
					_hype.Apply.MSBorderRadius(element);
				}
${endif}
			},
			
			'${BorderRadiusBottomLeft}' : function (value, element) {
				element.style['borderBottomLeftRadius'] = value;
				
				// firefox 3.6
				element.style["MozBorderRadiusBottomleft"] = value;

${ifdef supportInternetExplorer6789}
				// PIE IE
				if(_hype.browserInfo.ie < 9) {
					element.setAttribute("${HYPE_MS_BorderBottomLeftRadius}", value);
					_hype.Apply.MSBorderRadius(element);
				}
${endif}
			},
			
			'${BorderRadiusBottomRight}' : function (value, element) {
				element.style['borderBottomRightRadius'] = value;

				// firefox 3.6
				element.style["MozBorderRadiusBottomright"] = value;
				
${ifdef supportInternetExplorer6789}
				// PIE IE
				if(_hype.browserInfo.ie < 9) {
					element.setAttribute("${HYPE_MS_BorderBottomRightRadius}", value);
					_hype.Apply.MSBorderRadius(element);
				}
${endif}
			},
			
			'${VideoResourceGroupOid}' : function (value, element) {
				element.innerHTML = "";
			
				var objectEmbedSource;
				
				var resourceIDs = _hype.resourceGroups[value];
				if(resourceIDs == null) {
					return;
				}
				
				for(var i = 0; i < resourceIDs.length; i++) {
					var resourceID = resourceIDs[i];
					var resource = _hype.resources[resourceID];
					var mimeType = resource["${groupingType}"];
					var resourcePath = _hype.resourcePathForResourceID(resourceID);
					
					var sourceElement = element.ownerDocument.createElement("source");
					sourceElement.src = resourcePath;
					if(mimeType != null && (_hype.browserInfo.chrome == null || mimeType != "video/quicktime")) { // quicktime check for 4741: Quicktime videos do not play in Chrome
						sourceElement.setAttribute("type", mimeType);
					}
					
					if(objectEmbedSource == null && mimeType != "video/ogg" && mimeType != "video/webm") {
						objectEmbedSource = resourcePath;
					}
					
					element.appendChild(sourceElement);
				}

${ifdef supportInternetExplorer6789}				
				if(objectEmbedSource != null && _hype.browserInfo.ie < 9) {
					// replace the video tag with the div tag, and then put an embed to the quicktime plugin inside
					var div = element.ownerDocument.createElement("div");
					div.className = "HYPE_element";
					for(var i = 0; i < element.attributes.length; i++) {
						var attr = element.attributes.item(i);
						div.setAttribute(attr.name, attr.value);
					}
					if(element.hasChildNodes) {
						for(var i = 0; i < element.childNodes.length; i++) {
							div.appendChild(element.childNodes.item(i));
						}
					}
					div.style.cssText = element.style.cssText;
					
					element.parentNode.replaceChild(div, element);
										
					var controls = "false";
					var controlsAttributeOnDiv = div.getAttribute("controls");
					if(controlsAttributeOnDiv != null && (controlsAttributeOnDiv == "controls" || controlsAttributeOnDiv == "1" || controlsAttributeOnDiv == "True" || controlsAttributeOnDiv == "true")) {
						controls = "true";
					}

					var loop = "false";
					var loopAttributeOnDiv = div.getAttribute("loop");
					if(loopAttributeOnDiv != null && (loopAttributeOnDiv == "loop" || loopAttributeOnDiv == "1" || loopAttributeOnDiv == "True" || loopAttributeOnDiv == "true")) {
						loop = "true";
					}

					var mute = "100";
					var muteAttributeOnDiv = div.getAttribute("mute");
					if(muteAttributeOnDiv != null && (muteAttributeOnDiv == "mute" || muteAttributeOnDiv == "1" || muteAttributeOnDiv == "True" || muteAttributeOnDiv == "true")) {
						mute = "0";
					}
					
					var embedSource = "<embed src='" + objectEmbedSource + "'classid='clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B'codebase='http://apple.com/qtactivex/qtplugin.cab'width='" + div.style["width"] + "'height='" + div.style["height"] + "'enablejavascript='true'postdomevents='true'scale='tofit'name='embedobj_" + div.id + "'id='embedobj_" + div.id + "'controller='" + controls + "'loop='" + loop + "'volume='" + mute + "'autoplay='false'class='video'></embed>";
					div.innerHTML = embedSource;
					
					div.play = (function () {
						var embedobj = element.ownerDocument.embeds["embedobj_" + element.id];
						_hype.Apply['Play'](true, embedobj);
					});
					div.pause = (function () {
						var embedobj = element.ownerDocument.embeds["embedobj_" + element.id];
						_hype.Apply['Play'](false, embedobj);
					});
				}
${endif}
			},
			
			// this is internal for IE support
			'Play' : function (value, embedobj) {
                try {
                    if(value == true) {
						embedobj['Play']();
					} else {
						embedobj['Stop']();
					}
                } catch (err) {
                    window.setTimeout(function() { _hype.Apply['Play'](value, embedobj) }, 100);
                }
			},

			'${Autoplay}' : function (value, element) {
				// autoplay is now used by Hype's animation system
				element.autoplay = false;// (value != 0);
			},

			'${Controls}' : function (value, element) {
${ifdef videoExport}
				value = false;
${endif}
				element.setAttribute("controls", value);
				element.controls = (value != 0);

${ifdef supportInternetExplorer6789}
				var embedobj = element.ownerDocument.embeds["embedobj_" + element.id];
				
				if(embedobj != null && _hype.browserInfo.ie < 9) {
					try {
						var booleanValue = parseInt(value) != 0;
						embedobj['SetControllerVisible'](booleanValue);
					} catch(err) {
                        // retry once the object is loaded
						window.setTimeout(function() { _hype.Apply['${Controls}'](value, element) }, 100);
                    }
				}
${endif}
			},

			'${Muted}' : function (value, element) {
				element.setAttribute("mute", value);
				element.volume = (value != 0) ? "0.0" : "1.0";

${ifdef supportInternetExplorer6789}
				var embedobj = element.ownerDocument.embeds["embedobj_" + element.id];
				if(embedobj != null && _hype.browserInfo.ie < 9) {
					try {
						var booleanValue = parseInt(value) != 0;
						embedobj['SetMute'](booleanValue);

					} catch(err) {
                        // retry once the object is loaded
						window.setTimeout(function() { _hype.Apply['${Muted}'](value, element) }, 100);
                    }
				}
${endif}
			},

			'${Loop}' : function (value, element) {
				element.setAttribute("loop", value);
				element.loop = (value != 0);
${ifdef supportInternetExplorer6789}
				var embedobj = element.ownerDocument.embeds["embedobj_" + element.id];
				if(embedobj != null && _hype.browserInfo.ie < 9) {
					try {
						var booleanValue = parseInt(value) != 0;
						embedobj.SetIsLooping(booleanValue);
					} catch(err) {
						// retry once the object is loaded
						window.setTimeout(function() { _hype.Apply['${Loop}'](value, element) }, 100);
                    }
				}
${endif}
			},

			'${Position}' : function (value, element) {
				element.style.position = value;
			},

			'${Display}' : function (value, element) {
				element.style.display = value;
			},
			
			'${AltText}' : function (value, element) {
				element.setAttribute("title", value);
				element.setAttribute("alt", value);
			},

			'${BackgroundColor}' : function (value, element) {
				element.style.backgroundColor = value;
			},

			'${BackgroundGradientStartColor}' : function (value, element) {
				element.setAttribute("${HYPE_BackgroundGradientStartColor}", value);
				_hype.Apply.BackgroundGradient(element);
			},
			
			'${BackgroundGradientEndColor}' : function (value, element) {
				element.setAttribute("${HYPE_BackgroundGradientEndColor}", value);
				_hype.Apply.BackgroundGradient(element);
			},
			
			'${BackgroundGradientAngle}' : function (value, element) {
				element.setAttribute("${HYPE_BackgroundGradientAngle}", value);
				_hype.Apply.BackgroundGradient(element);
			},
			
			BackgroundGradient : function (element) {
				var backgroundGradientStartColor = element.getAttribute("${HYPE_BackgroundGradientStartColor}");
				if(backgroundGradientStartColor == null || backgroundGradientStartColor == "") {
					return;
				}
				var backgroundGradientEndColor = element.getAttribute("${HYPE_BackgroundGradientEndColor}");
				if(backgroundGradientEndColor == null || backgroundGradientEndColor == "") {
					return;
				}
				var backgroundGradientAngle = element.getAttribute("${HYPE_BackgroundGradientAngle}");
				if(backgroundGradientAngle == null) {
					return;
				}

				function generateGradientString(prefix, isSpecRotation) {
					var angle = (isSpecRotation == true) ? ((parseFloat(Math.abs(parseFloat(backgroundGradientAngle))) + 180) % 360) : ((parseFloat(360 - Math.abs(parseFloat(backgroundGradientAngle))) + 270) % 360);
					return "" + prefix + "linear-gradient(" + angle + "deg," + backgroundGradientStartColor + "," + backgroundGradientEndColor + ")";
				}
				
				if(_hype.browserInfo.webkit != null) {
					element.style.backgroundImage = generateGradientString(_hype.kSizeOptimizationWebKitPrefix, false);
				} else if(_hype.browserInfo.gecko != null) {
					element.style.backgroundImage = generateGradientString("-moz-", false);
				}
${ifdef supportInternetExplorer6789}
				 else if(_hype.browserInfo.ie < 10) {
					element.style["-pie-background"] = generateGradientString("", false);
				}
${endif}
				else if(_hype.browserInfo.opera < 15) {
					element.style.backgroundImage = generateGradientString("-o-", false);
				} else {
					element.style.backgroundImage = generateGradientString("", true);
				}
			},

			'${BackgroundImageResourceGroupOid}' : function (value, element) {
				var resourceID = _hype.bestImageResourceIDForResourceGroupOid(value);
				if(resourceID == null) {
					return;
				}

				var resourceName = _hype.resources[resourceID]['${resourceName}'];
				var resourcePath = _hype.resourcePathForResourceID(resourceID);

				//!! do not do this for webkit based browsers because they work the old way and this will cause a crash! (need to file)
				if((_hype.browserInfo.ff < 3.6 || _hype.browserInfo.ie < 9) && (element.style.backgroundRepeat == null || element.style.backgroundRepeat == "" || element.style.backgroundRepeat == "no-repeat")) {
					// need to create an img tag because IE8- and FF 3.5- can't scale background images
					var imgId = "img_" + element.id;
					var imgElement = document.getElementById(imgId);
					if(imgElement != null) {
						imgElement.src = resourcePath;
					} else {					
						imgElement = document.createElement("img");
						imgElement.src = resourcePath;
						imgElement.id = imgId;
						imgElement.style.position = "absolute";
						imgElement.style.width = "100%";
						imgElement.style.height = "100%";
						imgElement.style.top = "0";
						imgElement.style.left = "0";
						imgElement.style.zIndex = "-10000";
						element.appendChild(imgElement);
					}
					
					imgElement.setAttribute("${HYPE_Source}", imgElement.src);

${ifdef supportInternetExplorer6789}
					// PNG fixes for IE 6-8
					if(_hype.browserInfo.ie < 9 && resourceName.substr(resourceName.length-4).toLowerCase() == '.png') {
						// use AlphaImageLoader to load on IE 5-6 and make good looking PNGs on 7-8 (the src must be a blank gif)
						imgElement.src = _hype.resourcePathForBlankGif();
						var msAlphaImageLoader = _hype.kSizeOptimizationMSFilterPrefix + ".AlphaImageLoader(sizingMethod='scale',src='" + escapeURLForCSS(resourcePath) + "')";
						imgElement.setAttribute("${HYPE_MS_image_loader}", msAlphaImageLoader);
						
						// for pngs on IE 7-8, add a fix for a background color so the partially transparent regions don't show up as black
						var msBackgroundGradient = _hype.kSizeOptimizationMSFilterPrefix + ".gradient(startColorstr=#00FFFFFF,endColorstr=#00FFFFFF)";
						imgElement.setAttribute("${HYPE_MS_background}", msBackgroundGradient);
						_hype.Apply.ApplyMSFilters(imgElement);
					}
${endif}

					// need to set width/height of image
					_hype.Apply.UpdateFrame(element);
				} else {
					// use data url cached version instead
					var imageDataURL = _hype.imageResourceIDToDataURLMapping[resourceID];
					if(imageDataURL != null) {
						element.style.backgroundImage = "url('" + imageDataURL + "')";
					} else {
						element.style.backgroundImage = "url('" + escapeURLForCSS(resourcePath) + "')";
					}					
				}
			},

			'${BackgroundSize}' : function (value, element) {
				element.style['backgroundSize'] = value;
				
				// webkit
				element.style[_hype.kSizeOptimizationWebKitPrefix + "background-size"] = value;
				
				// mozilla
				element.style["MozBackgroundSize"] = value;
			},

			'${BackgroundOrigin}' : function (value, element) {
				element.style['backgroundOrigin'] = value;
				
				// webkit
				element.style[_hype.kSizeOptimizationWebKitPrefix + "background-origin"] = value;
				
				// mozilla
				element.style["MozBackgroundOrigin"] = value;
			},

			'${BackgroundRepeat}' : function (value, element) {
				// remove that extra img tag we added in backgroundImage
				if(value != null && value != "no-repeat") {
					var img = document.getElementById("img_" + element.id);
					if(img != null) {
						element.style.backgroundImage = "url('" + escapeURLForCSS(img.getAttribute("${HYPE_Source}")) + "')";
						img.parentNode.removeChild(img);
					}
				}
			
				element.style.backgroundRepeat = value;
			},

			'${Overflow}' : function (value, element) {
				element.style.overflow = value;
			},

			'${PaddingLeft}' : function (value, element) {
				element.style.paddingLeft = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},
			
			'${PaddingRight}' : function (value, element) {
				element.style.paddingRight = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},
			
			'${PaddingTop}' : function (value, element) {
				element.style.paddingTop = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},
			
			'${PaddingBottom}' : function (value, element) {
				element.style.paddingBottom = value;
				_hype.invalidateBrowserReportedSizeCacheForElement(element);
				_hype.Apply.UpdateFrame(element);
			},
			
			'${BoxShadowXOffset}' : function (value, element) {
				element.setAttribute("${HYPE_BoxShadowXOffset}", value);
				_hype.Apply.BoxShadow(element);
			},

			'${BoxShadowYOffset}' : function (value, element) {
				element.setAttribute("${HYPE_BoxShadowYOffset}", value);
				_hype.Apply.BoxShadow(element);
			},
			
			'${BoxShadowColor}' : function (value, element) {
				element.setAttribute("${HYPE_BoxShadowColor}", value);
				_hype.Apply.BoxShadow(element);
			},
			
			'${BoxShadowBlurRadius}' : function (value, element) {
				element.setAttribute("${HYPE_BoxShadowBlurRadius}", value);
				_hype.Apply.BoxShadow(element);
			},
						
			BoxShadow : function (element) {
				var boxShadowXOffset = element.getAttribute("${HYPE_BoxShadowXOffset}");
				if(boxShadowXOffset == null) {
					return;
				}
				var boxShadowYOffset = element.getAttribute("${HYPE_BoxShadowYOffset}");
				if(boxShadowYOffset == null) {
					return;
				}
				var boxShadowShadowColor = element.getAttribute("${HYPE_BoxShadowColor}");
				if(boxShadowShadowColor == null) {
					return;
				}
				var boxShadowBlurRadius = element.getAttribute("${HYPE_BoxShadowBlurRadius}");
				if(boxShadowBlurRadius == null) {
					return;
				}
				
				var xOffset = parseFloat(boxShadowXOffset);
				var yOffset = parseFloat(boxShadowYOffset);
				
				var boxShadowProperties = [_hype.kSizeOptimizationWebKitPrefix + "box-shadow" /* webkit */, "MozBoxShadow" /* mozilla */, "boxShadow" /* firefox 4.0+ */, "box-shadow" /* ie/standard */];

				// remove it so that IE can properly rotate
				if(xOffset == 0 && yOffset == 0 && parseFloat(boxShadowBlurRadius) == 0) {
					for(var i = 0; i < boxShadowProperties.length; i++) {
						if(element.style.removeAttribute) { // IE 6-8 does not have css.removeProperty, but removeAttribute will work
							element.style.removeAttribute(boxShadowProperties[i]);
						} else {
							element.style.removeProperty(boxShadowProperties[i]);
						}
					}
					
					return;
				}
				
				// apply
				var boxShadowValue = "" + xOffset + "px " + yOffset + "px " + boxShadowBlurRadius + " " + boxShadowShadowColor;
				for(var i = 0; i < boxShadowProperties.length; i++) {
					element.style[boxShadowProperties[i]] = boxShadowValue;
				}
			},


			'${TextShadowXOffset}' : function (value, element) {
				element.setAttribute("${HYPE_TextShadowXOffset}", value);
				_hype.Apply.TextShadow(element);
			},

			'${TextShadowYOffset}' : function (value, element) {
				element.setAttribute("${HYPE_TextShadowYOffset}", value);
				_hype.Apply.TextShadow(element);
			},
			
			'${TextShadowColor}' : function (value, element) {
				element.setAttribute("${HYPE_TextShadowColor}", value);
				_hype.Apply.TextShadow(element);
			},
			
			'${TextShadowBlurRadius}' : function (value, element) {
				element.setAttribute("${HYPE_TextShadowBlurRadius}", value);
				_hype.Apply.TextShadow(element);
			},
			
			TextShadow : function (element) {
				var textShadowXOffset = element.getAttribute("${HYPE_TextShadowXOffset}");
				if(textShadowXOffset == null) {
					return;
				}
				var textShadowYOffset = element.getAttribute("${HYPE_TextShadowYOffset}");
				if(textShadowYOffset == null) {
					return;
				}
				var textShadowShadowColor = element.getAttribute("${HYPE_TextShadowColor}");
				if(textShadowShadowColor == null) {
					return;
				}
				var textShadowBlurRadius = element.getAttribute("${HYPE_TextShadowBlurRadius}");
				if(textShadowBlurRadius == null) {
					return;
				}
				
				var xOffset = parseFloat(textShadowXOffset);
				var yOffset = parseFloat(textShadowYOffset);
				var blurRadius = parseFloat(textShadowBlurRadius);
				
				if(xOffset == 0 && yOffset == 0 && blurRadius == 0) {
					element.style["textShadow"] = "none";
				} else {
					element.style["textShadow"] = "" + xOffset + "px " + yOffset + "px " + textShadowBlurRadius + " " + textShadowShadowColor;
				}
			},
			
			'${FilterEffectBlur}' : function (value, element) {
				element.setAttribute("${HYPE_Blur}", value);
				_hype.Apply.FilterEffect(element);
				
				// workaround for #3485/chromium bug 161423
				if(_hype.browserInfo.chrome != null && element.style[_hype.kSizeOptimizationWebKitPrefix + "transform"] == "") {
					element.style[_hype.kSizeOptimizationWebKitPrefix + "transform"] = "none";
				}
			},

			'${FilterEffectSepia}' : function (value, element) {
				element.setAttribute("${HYPE_Sepia}", value);
				_hype.Apply.FilterEffect(element);
			},

			'${FilterEffectHue}' : function (value, element) {
				element.setAttribute("${HYPE_Hue}", value);
				_hype.Apply.FilterEffect(element);
			},

			'${FilterEffectSaturate}' : function (value, element) {
				element.setAttribute("${HYPE_Saturate}", value);
				_hype.Apply.FilterEffect(element);
			},

			'${FilterEffectBrightness}' : function (value, element) {
				element.setAttribute("${HYPE_Brightness}", value);
				_hype.Apply.FilterEffect(element);
			},

			'${FilterEffectContrast}' : function (value, element) {
				element.setAttribute("${HYPE_Contrast}", value);
				_hype.Apply.FilterEffect(element);
			},
			
			FilterEffect : function (element) {
				var blur = element.getAttribute("${HYPE_Blur}");
				var sepia = element.getAttribute("${HYPE_Sepia}");
				var hue = element.getAttribute("${HYPE_Hue}");
				var saturate = element.getAttribute("${HYPE_Saturate}");
				var brightness = element.getAttribute("${HYPE_Brightness}");
				var contrast = element.getAttribute("${HYPE_Contrast}");
				
				var filterString = "";
				
				if(blur != null && parseFloat(blur) != 0) {
					filterString += "blur(" + blur + "px) ";
				}
				if(sepia != null && parseFloat(sepia) != 0) {
					filterString += "sepia(" + sepia + ") ";
				}
				if(hue != null && parseFloat(hue) != 0) {
					filterString += "hue-rotate(" + hue + ") ";
				}
				if(saturate != null && parseFloat(saturate) != 1.0) {
					filterString += "saturate(" + saturate + ") ";
				}
				
				var brightnessAsFloat = parseFloat(brightness);
				if(brightness != null && brightnessAsFloat != 1.0) {
					// older webkits and even Hype misinterpreted the spec (-100%=black,0%=normal,100%=white), thus I add 1.0 to the brightness value for newer browsers
					// see http://code.google.com/p/chromium/issues/detail?id=168004
					if(_hype.browserInfo.safari == 6 || (_hype.browserInfo.ios != null && parseFloat(_hype.browserInfo.webkit) <= 536.26)) {
						brightnessAsFloat -= 1;
						if(brightnessAsFloat > 1.0) { // also older safari did not allow brightness beyond 1.0, which is now allowed with the spec
							brightnessAsFloat = 1;
						}
					}
					filterString += "brightness(" + brightnessAsFloat + ") ";	
				}
				if(contrast != null && parseFloat(contrast) != 1.0) {
					filterString += "contrast(" + contrast + ") ";
				}
				
				if(filterString == "") {
					element.style[_hype.kSizeOptimizationWebKitPrefix + 'filter'] = "none";
				} else {
					element.style[_hype.kSizeOptimizationWebKitPrefix + 'filter'] = filterString;
				}
			},			
			
			'${WordWrap}' : function (value, element) {
				element.style.wordWrap = value;
			},

			'${WhiteSpace}' : function (value, element) {
				element.style['whiteSpace'] = value;
			},

			'${WhiteSpaceCollapsing}' : function (value, element) {
				element.style['whiteSpaceCollapsing'] = value;
			},
				 
			'${ZIndex}' : function (value, element) {
				element.style.zIndex = value;
				
				if(element.parentNode.className == "HYPE_element_container") { // webkit 3d support
					element.parentNode.style.zIndex = value;
				}
			},

			CreateActionHandler : function (value, element) {
				return function(e) {
					for(var i = 0; i < value.length; i++) {
						var action = value[i];
					
						var type = action["${type}"];
						if(type == _hype.kActionJumpToScene) {
							var sceneSymbol = action["${sceneSymbol}"];
							var transition = action["${transition}"];
							var duration = action["${duration}"];
							if(sceneSymbol == null || sceneSymbol == _hype.kJumpToSceneOther) {
								var sceneIndex = _hype.indexOfSceneWithIdentifier(action["${sceneOid}"]);
								_hype.showScene(sceneIndex, transition, duration);
							} else if(sceneSymbol == _hype.kJumpToSceneNext) {
								_hype.showNextScene(transition, duration);
							} else if(sceneSymbol == _hype.kJumpToScenePrevious) {
								_hype.showPreviousScene(transition, duration);
							} else if(sceneSymbol == _hype.kJumpToSceneFirst) {
								_hype.showScene(0, transition, duration);
							} else if(sceneSymbol == _hype.kJumpToSceneLast) {
								_hype.showScene(_hype.scenes.length - 1, transition, duration);
							}
						}/* else if(type == kActionPresentMedia) {
							
						}*/ else if(type == _hype.kActionStartTimeline) {
							if(action["${timelineIdentifier}"] != null) {
								var timelineRun = _hype.timelineRunForIdentifier(action["${timelineIdentifier}"]);
								var playInReverse = (action["${playInReverse}"] != undefined) ? action["${playInReverse}"] : false;
								_hype.startTimelineRun(action["${timelineIdentifier}"], (element != null ? element.id : null), playInReverse);
							}
						} else if(type == _hype.kActionPauseTimeline) {
							if(action["${timelineIdentifier}"] != null) {
								var pauseTime = action["${pauseTime}"];
								_hype.pauseTimelineWithIdentifier(action["${timelineIdentifier}"], pauseTime);
							}
						} else if(type == _hype.kActionContinueTimeline) {
							if(action["${timelineIdentifier}"] != null) {
								var playInReverse = (action["${playInReverse}"] != undefined) ? action["${playInReverse}"] : false;
								_hype.continueTimelineWithIdentifier(action["${timelineIdentifier}"], playInReverse, true);
							}
						} else if(type == _hype.kActionGoToTimeInTimeline) {
							if(action["${timelineIdentifier}"] != null && action["${goToTime}"] != null) {
								_hype.goToTimeInTimelineWithIdentifier(action["${goToTime}"], action["${timelineIdentifier}"]);
							}
						} else if(type == _hype.kActionRunJavascript) {
							if(action["${javascriptOid}"] != null) {
								var functionName = _hype.javascriptMapping[action["${javascriptOid}"]];
								try {
									_hype['${functions}'][functionName](_hype['API'], element, e);
								} catch(err) {
									_hype.log("Error in " + functionName + ": " + err);
								}
							}
						} else if(type == _hype.kActionVisitURL) {
							var url = _hype.urlByReplacingCommonUserErrors(action["${goToURL}"]);
							if(url != null) {						
								var openInNewWindow = (action["${openInNewWindow}"] == true);
${ifdef supportInternetExplorer6789}
								if (_hype.browserInfo.ie < 9) {
									// button == 4 is the middle mouse button, mouse events prior to IE 9. It's set when cmd clicking as well.
									openInNewWindow = (openInNewWindow || e.button == 4);
								} else {
${endif}
									// button == 1 is set by FF when ctrl clicking on Windows; meta == true is set by FF when command clicking on OS X.
									openInNewWindow = (openInNewWindow || e.button == 1 || e.metaKey == true);
${ifdef supportInternetExplorer6789}
								}
${endif}
								if(openInNewWindow) {
									if ((_hype.browserInfo.ie < 9 || _hype.browserInfo.quirksmode) || _hype.browserInfo.ff != null) {
										// IE 6 - 8 and IE 9+ in quirks mode don't respect createEvent, initMouseEvent, or dispatchEvent. Firefox reputedly does, but versions before FF6 seem to eat simulated click events; from reading the tea leaves of their bugs, I presume this is purposeful for "security" reasons. FF6-18 (the current Nightly) work in normal mouse click scenarios, but swallow events when the user cmd-clicks. Fall back to naive behavior for these browsers.
										window.open(url, "_blank");
									} else if ((_hype.browserInfo.ie == 9 || _hype.browserInfo.opera < 15) && !(e instanceof MouseEvent)) {
										// window.open must be used on IE 9 and Opera for non-mouse events, as those browsers raise errors when trying to create an artifical mouse event if the user didn't click. (#3782) This logic silently fails on Safari 6 when pop-up blocking is enabled, so we're isolating this case to just IE 9 and Opera.
										window.open(url, "_blank");
									} else {
										// Create an a element in the DOM and virtually click it, providing any current modifier keys. Lets the browser do the right thing w.r.t. opening the link in a new window or tab.
										var temporaryLink = document.createElement('a');
										temporaryLink.setAttribute("href", url);

										// IE>=9 don't repect the middle-mouse button or meta key triggers when handling artifical clicks – they're treated as normal clicks.  We can circumvent that behavior by seting a _blank target if we detect a middle-mouse button click or a meta key click. Safari, Chrome and Opera all do the right thing with or without the _blank target, but the _blank target is necessary to create a new window if the Hype animation is embedded in an iframe
										temporaryLink.setAttribute("target", "_blank");

										document.body.appendChild(temporaryLink);
										var clickEvent = document.createEvent("MouseEvents");
										clickEvent.initMouseEvent("click", e.bubbles, e.cancelable, e.view, e.detail, e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey, e.shiftKey, e.metaKey, e.button, document.body.parentNode);
										temporaryLink.dispatchEvent(clickEvent);
										document.body.removeChild(temporaryLink);
									}
								} else {
									// This is the only way to open links in the same page which works in desktop browsers, iBooks, and in iOS stand-alone web apps, and when Hype animations are embedded in iframes
									window.top.location = url;
								}
							}
						} else if(type == _hype.kActionComposeEmail) {	
							var toAddress = action["${emailToAddress}"];
							var subject = action["${emailSubject}"];
							var body = action["${emailBody}"];
							var url = "mailto:";
							if (toAddress != null) {
								url += escape(toAddress);
							}	
							if (subject != null || body != null) {
								url += "?";
								var parts = Array();
								if (subject != null) {
									parts.push("subject="+encodeURIComponent(subject));
								}
								if (body != null) {
									parts.push("body="+encodeURIComponent(body));
								}
								url += parts.join("&");
							}
							if (url != "mailto:") {
								window.top.location = url;
							}
						} else if(type == _hype.kActionPlaySound) {
							var resourceGroupOid = action["${resourceGroupOid}"];
							var loop = action["${loop}"];
							if(loop != true) {
								loop = false;
							}
							if(resourceGroupOid != null) {
								_hype.playAudioResourceGroupOid(resourceGroupOid, loop);
							}
						} else if(type == _hype.kActionPauseSound) {
							var resourceGroupOid = action["${resourceGroupOid}"];
							if(resourceGroupOid != null) {
								_hype.pauseAudioResourceGroupOid(resourceGroupOid);
							}
						}
					}
				};
			},

			'${ActionHandlerOnMouseClick}' : function (value, element) {
				var actionHandler = _hype.Apply.CreateActionHandler(value["${actions}"], element);
				if (_hype.useTouchEvents) {
					var options = { fingers: 1, gestureType:_hype.kGestureTap };
					_hype.addGestureHandler(options, element, actionHandler);
					element.style["-webkit-tap-highlight-color"] = "rgba(0,0,0,0)";
				}
				_hype.addActionHandler("click", element, actionHandler, true);
			},
			
			'${ActionHandlerOnMouseOver}' : function (value, element) {
				_hype.addActionHandler("mouseover", element, _hype.Apply.CreateActionHandler(value["${actions}"], element), false);
			},
			
			'${ActionHandlerOnMouseOut}' : function (value, element) {
				_hype.addActionHandler("mouseout", element, _hype.Apply.CreateActionHandler(value["${actions}"], element), false);
			},

			'${ActionHandlerOnMouseUp}' : function (value, element) {
				var actionHandler = _hype.Apply.CreateActionHandler(value["${actions}"], element);
				if (_hype.useTouchEvents) {
					_hype.addActionHandler("touchend", element, actionHandler, true);
					element.style["-webkit-tap-highlight-color"] = "rgba(0,0,0,0)";
				}
				_hype.addActionHandler("mouseup", element, actionHandler, true);
			},

			'${ActionHandlerOnMouseDown}' : function (value, element) {
				var actionHandler = _hype.Apply.CreateActionHandler(value["${actions}"], element);
				if (_hype.useTouchEvents) {
					_hype.addActionHandler("touchstart", element, actionHandler, true);
					element.style["-webkit-tap-highlight-color"] = "rgba(0,0,0,0)";
				}
				_hype.addActionHandler("mousedown", element, actionHandler, true);
			},
			
			'${ActionHandlerOnDrag}' : function (value, element) {
				_hype.addDragGestureHandler(value, element);
			},
			
			CreateButtonHandler : function (value, element) {
				return function(e) {
					_hype.applyButtonFromTimelineRun(e, value, _hype.idReverseMapping[element.id]);
				};
			},
			
			CreateButtonResetHandler : function (value, element) {
				return function(e) {
					_hype.resetButtonFromTimelineRun(e, value, _hype.idReverseMapping[element.id]);
				};
			},
			
			'${ButtonHover}' : function (value, element) {
				_hype.addActionHandler("mouseover", element, _hype.Apply.CreateButtonHandler(value, element), false);
				_hype.addActionHandler("mouseout", element, _hype.Apply.CreateButtonResetHandler(value, element), false);
			},
			
			'${ButtonPress}' : function (value, element) {
				if (_hype.useTouchEvents) {
					_hype.addActionHandler("touchstart", element, _hype.Apply.CreateButtonHandler(value, element), false);
					_hype.addActionHandler("touchmove", element, _hype.Apply.CreateButtonResetHandler(value, element), false);
					_hype.addActionHandler("touchend", element, _hype.Apply.CreateButtonResetHandler(value, element), false);
					element.style["-webkit-tap-highlight-color"] = "rgba(0,0,0,0)";
				}
				_hype.addActionHandler("mousedown", element, _hype.Apply.CreateButtonHandler(value, element), false);
				_hype.addActionHandler("mouseup", element, _hype.Apply.CreateButtonResetHandler(value, element), false);	
			},

			'${IFrameType}' : function (value, element) {
				element.setAttribute("${HYPE_IFrameType}", value);
				_hype.Apply.IFrameSource(element);
			},

			'${IFrameHTML}' : function (value, element) {
				element.setAttribute("${HYPE_IFrameHTML}", value);
				_hype.Apply.IFrameSource(element);
			},
			
			'${IFrameURL}' : function (value, element) {
				element.setAttribute("${HYPE_IFrameURL}", value);
				_hype.Apply.IFrameSource(element);
			},
			
			IFrameSource : function (element) {
				var type = element.getAttribute("${HYPE_IFrameType}");
				if(type != null) {
					var iframeSrc = "";
					if(type == "1") { // url
						iframeSrc = _hype.urlByReplacingCommonUserErrors(element.getAttribute("${HYPE_IFrameURL}"));
					} else if(type == "0") { // html
						iframeSrc = "" + _hype.resourcesFolderName + "/" + element.getAttribute("${HYPE_IFrameHTML}");
					}
					
					var iframeInnerHTML = "<iframe frameBorder='0'style='width:100%;height:100%;border:none;'src='" + iframeSrc + "'></iframe>";
					
					// fix for iBooks scrolling issue <rdar://problem/10798491> Cannot scroll iframes in iBooks on iPad
					if(_hype.browserInfo.ios != null) {
						iframeInnerHTML = "<div style='overflow:auto;-webkit-overflow-scrolling:touch;width:100%;height:100%;'>" + iframeInnerHTML + "</div>";
					}
					
					element.innerHTML = iframeInnerHTML;
				}
			},
			
			'${InnerHTML}' : function (value, element) {
				var img = document.getElementById("img_" + element.id);
				var imgClone = (img != null) ? img.cloneNode(true) : null;			
				element.innerHTML = value;				

				// execute any embedded <script>...</script> javascripts (those with src= will not work, see #868)
				var scripts = element.getElementsByTagName("script");
				for(var i = 0; i < scripts.length; i++) {
					if(scripts[i].src == "") {
						// better form of eval(scripts[i].text) for IE and Firefox (taken from jquery)
						(window.execScript || function(data) { window["eval"].call(window, data); })(scripts[i].text);
					}
				}

				if(imgClone != null) {
					element.appendChild(imgClone);
				}
			},
			
			'${AdditionalCSS}' : function (value, element) {
				element.style.cssText += "\n" + value;
			},
			
			'${TagName}' : function (value, element) {
				// can't change this after the fact!
			},
			
			'${Parent}' : function (value, element) {
				var childElement = element;
				var childContainer = element.parentNode;
				if(childContainer != null && childContainer.className == "HYPE_element_container") {
					childElement = childContainer;
				}
				var newParentElement = document.getElementById(_hype.idMapping[value]);
				var oldParentElement = childElement.parentNode;
				if(newParentElement == null || newParentElement == childElement || newParentElement == element || newParentElement == oldParentElement) {
					return;
				}
				
				oldParentElement.removeChild(childElement);
				newParentElement.appendChild(childElement);
			}
			
		});

