(function HYPE_DocumentLoader() {
	var resourcesFolderName = "${resourcesFolderName}";
	var documentName = "${documentName}";
	var documentLoaderFilename = "${documentLoaderFilename}";
	var mainContainerID = "${mainContainerID}";

	// find the URL for this script's absolute path and set as the resourceFolderName
	if("${unquote quickLookPreview}" == false) {
		try {
			var scripts = document.getElementsByTagName('script');
			for(var i = 0; i < scripts.length; i++) {
				var scriptSrc = scripts[i].src;
				if(scriptSrc != null && scriptSrc.indexOf(documentLoaderFilename) != -1) {
					resourcesFolderName = scriptSrc.substr(0, scriptSrc.lastIndexOf("/"));
					break;
				}
			}
		} catch(err) {	}
	}

	if("${unquote inlineHypeJS}" == false) {
		// load HYPE.js if it hasn't been loaded yet
		if(window["HYPE_${version}"] == null) {
			if(window['${HYPE_DocumentsToLoad_}${version}'] == null) {
				window['${HYPE_DocumentsToLoad_}${version}'] = Array();
				window['${HYPE_DocumentsToLoad_}${version}'].push(HYPE_DocumentLoader);

				var headElement = document.getElementsByTagName('head')[0];
				var scriptElement = document.createElement('script');
				var browserMatches = navigator.userAgent.match(/MSIE (\d+\.\d+)/);
				var ieVersion = (parseFloat(browserMatches && browserMatches[1]) || null);
				var runtimeFilename = (ieVersion != null && ieVersion < 10) ? 'HYPE.ie.js' : 'HYPE.js';
				scriptElement.type= 'text/javascript';
				scriptElement.src = resourcesFolderName + '/' + runtimeFilename + '?hype_version=${version}';
				headElement.appendChild(scriptElement);
			} else {
				window['${HYPE_DocumentsToLoad_}${version}'].push(HYPE_DocumentLoader);
			}
			return;
		}
	}

	var globalHypeDocuments = window['HYPE']['documents'];
	
	// handle attempting to load multiple times
	if(globalHypeDocuments[documentName] != null) {
		var index = 1;
		var originalDocumentName = documentName;
		do {
			documentName = "" + originalDocumentName + "-" + (index++);
		} while(globalHypeDocuments[documentName] != null);
		
		var allDivs = document.getElementsByTagName("div");
		var foundEligibleContainer = false;
		for(var i = 0; i < allDivs.length; i++) {
			if(allDivs[i].id == mainContainerID && allDivs[i].getAttribute("${HYPE_documentName}") == null) {
				var index = 1;
				var originalMainContainerID = mainContainerID;
				do {
					mainContainerID = "" + originalMainContainerID + "-" + (index++);
				} while(document.getElementById(mainContainerID) != null);
				
				allDivs[i].id = mainContainerID;
				foundEligibleContainer = true;
				break;
			}
		}
		
		if(foundEligibleContainer == false) {
			return;
		}
	}

	var hypeDoc = new HYPE_${version}();

	var attributeTransformerMapping = "${unquote attributeTransformerMapping}";

	var resources = "${unquote resources}";

	var headAdditions = "${unquote headAdditions}";

	var scenes = "${unquote scenes}";

	var javascripts = Array() /* for minifier */, javascripts = "${unquote javascripts}";

	var functions = {};
	var javascriptMapping = {};
	for(var i = 0; i < javascripts.length; i++) {
		try {
			javascriptMapping[javascripts[i].identifier] = javascripts[i].name;
			functions[javascripts[i].name] = eval("(function(){return " + javascripts[i].source + "})();");
		} catch (e) {
			hypeDoc['log'](e);
			functions[javascripts[i].name] = (function () {});
		}
	}

	hypeDoc['${setAttributeTransformerMapping}'](attributeTransformerMapping);
	hypeDoc['${setResources}'](resources);
	hypeDoc['${setHeadAdditions}'](headAdditions);
	hypeDoc['${setScenes}'](scenes);
	hypeDoc['${setOriginalSceneSize}']("${unquote width}", "${unquote height}");
	hypeDoc['${setJavascriptMapping}'](javascriptMapping);
	hypeDoc['${functions}'] = functions;
	hypeDoc['${setCurrentSceneIndex}']("${unquote initialSceneIndex}");
	hypeDoc['${setMainContentContainerID}'](mainContainerID);
	hypeDoc['${setResourcesFolderName}'](resourcesFolderName);
	hypeDoc['${setShowHypeBuiltWatermark}']("${unquote showHypeBuiltWatermark}");
	hypeDoc['${setShowLoadingPage}']("${unquote showLoadingPage}");
	hypeDoc['${setDrawSceneBackgrounds}']("${unquote drawSceneBackgrounds}");
	hypeDoc['${setGraphicsAcceleration}']("${unquote useGraphicsAcceleration}");
	hypeDoc['${setUseTouchEvents}']("${unquote useTouchEvents}");
	hypeDoc['${setDocumentName}'](documentName);

	globalHypeDocuments[documentName] = hypeDoc['API'];
	document.getElementById(mainContainerID).setAttribute("${HYPE_documentName}", documentName);

	hypeDoc['${documentLoad}'](this.body);
}());

